%% Code to generate Fig 5b
% Path gain estimation error for different choices of voltage levels

clear all
close all
clc

aspread_aoa = 30; no_sim = 10^6;
case_val = 1;
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load)
figure
plot(SNR_dB, 10*log10(MSE_sd_gain), 'k:','LineWidth',1.2)
hold on


aspread_aoa = 30;
case_val = 0;
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load)
plot(SNR_dB, 10*log10(MSE_sd_gain), 'b-','LineWidth',1.2)
hold on
plot(SNR_dB, 10*log10(MSE_a_gain), 'r--','LineWidth',1.2)


legend('SD, arbitrary c','SD, proposed c','UQ');
legend('location','southwest')
xlabel('SNR (dB)')
ylabel('Path gain NMSE (dB)')
grid on
xlim([-15 15])
savefig('Fig5c.fig')
saveas(gcf,'Fig5c','epsc')